/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8238.DeviceView;

import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8238.DeviceView.Chassis;
import ibm.nways.jdm8238.DeviceView.ChassisLike;
import ibm.nways.jdm8238.DeviceView.DefaultStatus;
import ibm.nways.jdm8238.DeviceView.PortLike;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.WidgetCookie;
import java.util.ResourceBundle;

public class Port
implements PortLike {
    private Status statusRef;
    private GraphicImage portGraphicImage;
    private int portIndex;
    private int modSlotPos;
    private int modSlotIndex;
    private ChassisLike chassis;
    private GenModel portTable;
    protected static final String BUNDLE_NAME = "ibm.nways.jdm8238.DeviceView.GraphicResources";
    protected static ResourceBundle resources = ResourceBundle.getBundle("ibm.nways.jdm8238.DeviceView.GraphicResources");
    private GraphicContainer portContainer = new GraphicContainer();
    private GraphicContainer graphicContainer;
    private JdmBrowser jdmBrowser;

    public Port(JdmBrowser jdmBrowser, ChassisLike chassisLike, GraphicContainer graphicContainer, int n, int n2, GenModel genModel) {
        this.graphicContainer = graphicContainer;
        this.chassis = chassisLike;
        this.jdmBrowser = jdmBrowser;
        this.modSlotPos = this.modSlotPos;
        this.modSlotIndex = n;
        this.portIndex = n2;
        this.portTable = genModel;
    }

    public void setCommonInformation() {
    }

    public void setSpecificInformation() {
    }

    public I18NMsgFormat getFlyOverText() {
        Object[] objectArray = new Object[3];
        objectArray[0] = new Integer(this.portIndex);
        String string = "rj45";
        objectArray[1] = resources.getString(string);
        objectArray[2] = ((Chassis)this.chassis).getTRPortMACAddress(this.modSlotIndex, this.portIndex);
        string = ((String)objectArray[2]).equals("") ? "port_tr_nomac" : "port_tr_mac";
        return new I18NMsgFormat(BUNDLE_NAME, string, objectArray);
    }

    public void draw() {
        int n = 22;
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Index.PortIndex", new Integer(this.portIndex));
        modelInfo.add("Index.PortSlotIndex", new Integer(this.modSlotIndex));
        String string = "port_" + this.portIndex;
        WidgetCookie widgetCookie = new WidgetCookie(string, BUNDLE_NAME, modelInfo, "ibm.nways.jdm8238.WCDefault", this.portTable, this.jdmBrowser, n, "ibm.nways.jdm8238.eui.PortsDummyPanel");
        this.portGraphicImage = widgetCookie.GetImage();
        I18NMsgFormat i18NMsgFormat = this.getFlyOverText();
        this.statusRef = DefaultStatus.getDefaultStatus();
        this.portGraphicImage.setStatus(this.statusRef);
        if (this.portTable != null) {
            ((Chassis)this.chassis).askStatus(this.portTable, this.portGraphicImage, modelInfo, this);
        }
        this.portGraphicImage.setFlyOver(new GraphicFlyOver(i18NMsgFormat.getTranslation()));
        this.portContainer.add((GraphicContainer)widgetCookie);
        this.graphicContainer.add(this.portContainer);
        try {
            ModelInfo modelInfo2 = modelInfo;
            NavigationContext navigationContext = new NavigationContext();
            NavInitialRow.setInitialRow((NavigationContext)navigationContext, (ModelInfo)modelInfo2);
            GraphicActionNavigate graphicActionNavigate = new GraphicActionNavigate((GraphicHandler)this.jdmBrowser, new NavigationDestination("ibm.nways.jdm8238.eui.PortsPanel", (RemoteModel)this.portTable), navigationContext);
            this.portGraphicImage.setAction((GraphicAction)graphicActionNavigate);
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 5, this, "draw", exception);
            return;
        }
    }
}

